/**
 * Created by lei.wang_1 on 2016/8/19.
 */
appModule.controller('UploadCtrl', ['$scope', 'api', 'utils', '$translate', 'log', function ($scope, api, utils, translate, log) {
    $scope.showUploadPanel = function (callback) {
        $scope.uploadCallback = callback;
        $scope.readyToUploadImages = [];
    };

    $scope.onUploadCancel = function () {
        $scope.uploadCallback = null;
        $scope.readyToUploadImages = [];
    };

    $scope.onUploadConfirm = function () {
        if (!$scope.isDisableSaveUploadImage()) {
            if ($scope.uploadCallback && $scope.readyToUploadImages && $scope.readyToUploadImages.length > 0) {
                var data = {
                    errorCode: 0,
                    paths: []
                };
                $scope.readyToUploadImages.forEach(function (img) {
                    if (img.remoteURL) {
                        data.paths.push(img.remoteURL);
                    }
                });
                $scope.uploadCallback(data);
            }
            $scope.onUploadCancel();
        }
    };

    $scope.isDisableSaveUploadImage = function () {
        if (!$scope.readyToUploadImages || $scope.readyToUploadImages.length == 0) {
            return true;
        }

        var index = $scope.readyToUploadImages.findIndex(function (image) {
            return image.remoteURL;
        });

        return index < 0;
    };

    $scope.addUploadImages = function (isContinue) {
        if($scope.isUploadingImages){
            return;
        }
        utils.openImageDialog(function (data) {
            if (data.errorCode === 0) {
                if (data.paths && data.paths.length > 0) {
                    utils.applyScope($scope, function () {
                        data.paths.forEach(function (path) {
                            $scope.readyToUploadImages.push({
                                url: path,
                                size: utils.getFileSize(path)
                            })
                        });
                    });
                }
            } else {
                api.notifyError(data.msg);
            }
        }, 0, true);
    };

    $scope.removeUploadImage = function (index, image, e) {
        $scope.readyToUploadImages.splice(index, 1);
    };

    $scope.uploadImages = function () {
        var urls = [];
        $scope.readyToUploadImages.forEach(function (img) {
            if (img.url && !img.remoteURL) {
                urls.push(img.url);
            }
        });
        $scope.isUploadingImages = true;
        var promise = utils.uploadFiles(urls, function (data, percent) {
            var index = $scope.readyToUploadImages.findIndex(function (img) {
                return img.url == data.originalURL;
            });
            utils.applyScope($scope,function() {
                $scope.readyToUploadImages[index].percent = percent;
            });
        }, function (data) {
            utils.applyScope($scope,function(){
                $scope.readyToUploadImages.forEach(function (img) {
                    if (data.originalURL == img.url) {
                        img.remoteURL = data.newURL;
                        img.percent = 100;
                    }
                });
            });
        });

        promise.then(function (result) {
            utils.applyScope($scope, function () {
                $scope.isUploadingImages = false;
            });
        });
    };

    var stopWatchReadyToUploadImages = $scope.$watch('readyToUploadImages', function (newV, oldV) {
        var count = 0, size = 0;
        if (newV && Array.isArray(newV)) {
            count = newV.length;
            for (var i = 0; i < newV.length; i++) {
                size += newV[i].size;
            }
        }
        size = utils.getSizeText(size);
        $scope.uploadImageHeaderMsg = translate.instant('publish.image-upload-title', {count: count, size: size});
    }, true);

    var offShowUploadPanel = $scope.$on('show_upload_panel',function(e,data){
        $scope.currentType = data.type;
        $scope.showUploadPanel(data.callback);
    });

    $scope.$on("$destroy", function () {
        stopWatchReadyToUploadImages();
        offShowUploadPanel();
    });
}]);